﻿using System.Windows;
using System.Windows.Controls;
using System.Windows.Interactivity;
using System.Windows.Navigation;
using mshtml;

namespace Azyobuzi.Twikoto2.Behaviors
{
    class GetPinCodeBehavior : Behavior<WebBrowser>
    {
        protected override void OnAttached()
        {
            base.OnAttached();
            this.AssociatedObject.LoadCompleted += this.AssociatedObject_LoadCompleted;
        }

        protected override void OnDetaching()
        {
            this.AssociatedObject.LoadCompleted -= this.AssociatedObject_LoadCompleted;
            base.OnDetaching();
        }

        private void AssociatedObject_LoadCompleted(object sender, NavigationEventArgs e)
        {
            var doc = (HTMLDocument)((WebBrowser)sender).Document;
            var kbds = doc.getElementsByTagName("kbd");
            if (kbds.length == 0)
                return;
            var kbd = kbds.item(index: 0);
            this.PinCode = ((string)kbd.innerText).Trim();
        }


        public string PinCode
        {
            get { return (string)GetValue(PinCodeProperty); }
            set { SetValue(PinCodeProperty, value); }
        }

        // Using a DependencyProperty as the backing store for PinCode.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty PinCodeProperty =
            DependencyProperty.Register(
                "PinCode",
                typeof(string),
                typeof(GetPinCodeBehavior),
                new FrameworkPropertyMetadata(null,
                    FrameworkPropertyMetadataOptions.BindsTwoWayByDefault));

        
    }
}
